/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.util;

import java.util.Enumeration;
import java.util.Hashtable;

public final class KeywordAvoider {
    private Hashtable _keywordMap = new Hashtable();
    private String _avoidPrefix = "_";
    private boolean _caseSensitive = true;

    public void avoid(String keyword) {
        this.avoid(keyword, String.valueOf(this._avoidPrefix).concat(String.valueOf(keyword)));
    }

    public void avoid(String keyword, String replacement) {
        if (!this._caseSensitive) {
            keyword = keyword.toLowerCase();
        }
        this._keywordMap.put(keyword, replacement);
    }

    public void avoid(Hashtable keywords) {
        Enumeration e = keywords.keys();
        while (e.hasMoreElements()) {
            String keyword = (String)e.nextElement();
            String replacement = (String)keywords.get(keyword);
            this.avoid(keyword, replacement);
        }
    }

    public void avoidPrefix(String prefix) {
        this._avoidPrefix = prefix;
    }

    public void caseSensitive(boolean sensitivity) {
        this._caseSensitive = sensitivity;
    }

    public String convertSimpleName(String name) {
        String realReplacement;
        if (name == null) {
            return null;
        }
        String replacement = (String)this._keywordMap.get(!this._caseSensitive ? name.toLowerCase() : name);
        if (replacement == null) {
            return name;
        }
        if (!this._caseSensitive && replacement.equalsIgnoreCase(realReplacement = String.valueOf(this._avoidPrefix).concat(String.valueOf(name)))) {
            return realReplacement;
        }
        return replacement;
    }
}

